<?php
include('db.php');

$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$sql = "SELECT * FROM urunler WHERE id = $product_id";
$result = $conn->query($sql);
$product = $result->fetch_assoc();

$modulSorgu = "SELECT * FROM moduller WHERE urun_id = $product_id";
$modulSonuc = $conn->query($modulSorgu);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($product['urun_adi']) ?> - Detay</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">


    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f8;
            margin: 0;
            padding: 0;
        }
        .product-detail {
            max-width: 700px;
            margin: 30px auto;
            background: #fff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            text-align: center;
        }
        .product-detail img {
            max-width: 100%;
            max-height: 300px;
            border-radius: 10px;
            object-fit: cover;
        }
        input[type="number"] {
            width: 140px;
            padding: 10px;
            margin: 8px;
            border: 1px solid #ccc;
            border-radius: 6px;
        }
        button {
            padding: 10px 18px;
            background-color: #2ecc71;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
        button:hover {
            background-color: #27ae60;
        }
        .result {
            margin-top: 15px;
            font-weight: bold;
            color: #2c3e50;
        }
        .geri-link {
            margin-top: 20px;
            display: inline-block;
            text-decoration: none;
            color: #3498db;
        }
        .geri-link:hover {
            text-decoration: underline;
        }
        .modul-item {
            width: 180px;
            padding: 10px;
            background: #fff;
            border: 1px solid #ccc;
            border-radius: 8px;
            text-align: center;
        }
        .modul-item img {
            max-width: 100%;
            border-radius: 6px;
            height: 100px;
            object-fit: cover;
        }
        .secilen-modul {
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }
        .modul-alani {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }
    </style>
</head>
<body>

<div class="container my-5">
    <h2 class="text-center mb-4"><?= htmlspecialchars($product['urun_adi']) ?></h2>

    <div class="row g-4">
        <!-- Modül Seçimi -->
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Modül Seçimi</h5>
                </div>
                <div class="card-body">
                    <?php while($modul = $modulSonuc->fetch_assoc()): ?>
                        <div class="border-bottom pb-3 mb-3">
                            <h6><?= htmlspecialchars($modul['modul_adi']) ?></h6>
                            <p><strong>Fiyat:</strong> <?= number_format($modul['satis_fiyati'], 2) ?> ₺</p>
                            <div class="input-group mb-2" style="max-width: 250px;">
                                <input type="number" id="adet_<?= $modul['id'] ?>" class="form-control" placeholder="Adet" min="1">
                                <button class="btn btn-success" onclick="modulEkle(<?= $modul['id'] ?>, '<?= htmlspecialchars($modul['gorsel']) ?>', <?= $modul['satis_fiyati'] ?>, <?= $modul['alis_fiyati'] ?>, '<?= htmlspecialchars($modul['modul_adi']) ?>')">Ekle</button>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>

            <div class="mt-3">
                <a href="product_list.php" class="btn btn-secondary">← Ürün Listesine Geri Dön</a>
            </div>
        </div>

        <!-- Seçilen Modüller & İndirim -->
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">Seçilen Modüller</h5>
                </div>
                <div class="card-body" id="seciliModuller" style="min-height: 100px;">
                    Henüz modül seçilmedi.
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0">İndirim Uygula</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <input type="number" id="modulYuzdeIndirim" class="form-control mb-2" placeholder="% Yüzdelik İndirim">
                        <button class="btn btn-primary w-100" onclick="modulYuzdeIndirimUygula()">Yüzdelik İndirim Uygula</button>
                    </div>

                    <div class="mb-3">
                        <input type="number" id="modulTlIndirim" class="form-control mb-2" placeholder="₺ TL İndirim">
                        <button class="btn btn-primary w-100" onclick="modulTlIndirimUygula()">TL İndirim Uygula</button>
                    </div>

                    <div id="modulIndirimSonuc" class="fw-bold text-dark mt-2"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    const secilenler = {};

    function modulEkle(id, gorsel, fiyat, alisFiyati, modulAdi) {
        const adetInput = document.getElementById('adet_' + id);
        const adet = parseInt(adetInput.value);
        if (!adet || adet <= 0) {
            alert("Lütfen geçerli bir adet giriniz.");
            return;
        }

        if (secilenler[id]) {
            secilenler[id].adet += adet;
        } else {
            secilenler[id] = {
                gorsel: gorsel,
                fiyat: fiyat,
                alisFiyati: alisFiyati,
                adet: adet,
                modulAdi: modulAdi
            };
        }

        renderSecilenler();
        adetInput.value = '';
    }

    function renderSecilenler() {
        const container = document.getElementById('seciliModuller');
        container.innerHTML = '';

        let toplamTutar = 0;
        let toplamAlisFiyati = 0;

        for (let id in secilenler) {
            const modul = secilenler[id];
            const urunToplam = modul.fiyat * modul.adet;
            const alisToplam = modul.alisFiyati * modul.adet;
            toplamTutar += urunToplam;
            toplamAlisFiyati += alisToplam;

            const div = document.createElement('div');
            div.classList.add('secilen-modul');
            div.innerHTML = 
                `<h4>${modul.modulAdi}</h4>
                <p><strong>Fiyat:</strong> ${modul.fiyat.toFixed(2)} ₺ x ${modul.adet} = <strong>${urunToplam.toFixed(2)} ₺</strong></p>`;
            container.appendChild(div);
        }

        if (toplamTutar === 0) {
            container.innerText = 'Henüz modül seçilmedi.';
        } else {
            const toplamDiv = document.createElement('div');
            toplamDiv.style.marginTop = '15px';
            toplamDiv.innerHTML = `<strong>Toplam Tutar: ${toplamTutar.toFixed(2)} ₺</strong>`;
            container.appendChild(toplamDiv);

            const karMarji = toplamTutar - toplamAlisFiyati;
            const karMarjiDiv = document.createElement('div');
            karMarjiDiv.style.marginTop = '15px';
            karMarjiDiv.innerHTML = `<strong>İşlem kodu: LORA${karMarji}-GTXGY-FUAR</strong>`;
            container.appendChild(karMarjiDiv);
        }
    }

    function modulYuzdeIndirimUygula() {
        const yuzde = parseFloat(document.getElementById("modulYuzdeIndirim").value);
        const sonucAlani = document.getElementById("modulIndirimSonuc");

        let toplam = 0;
        for (let id in secilenler) {
            toplam += secilenler[id].fiyat * secilenler[id].adet;
        }

        if (isNaN(yuzde) || yuzde < 0) {
            sonucAlani.innerText = "Lütfen geçerli bir yüzde giriniz.";
            return;
        }

        const indirimTutar = toplam * (yuzde / 100);
        const yeniFiyat = toplam - indirimTutar;

        sonucAlani.innerHTML = 
            `Uygulanan İndirim: %${yuzde.toFixed(2)}<br>
            İndirim Tutarı: ${indirimTutar.toFixed(2)} ₺<br>
            İndirimli Satış Fiyatı: ${yeniFiyat.toFixed(2)} ₺`;
    }

    function modulTlIndirimUygula() {
        const tl = parseFloat(document.getElementById("modulTlIndirim").value);
        const sonucAlani = document.getElementById("modulIndirimSonuc");

        let toplam = 0;
        for (let id in secilenler) {
            toplam += secilenler[id].fiyat * secilenler[id].adet;
        }

        if (isNaN(tl) || tl < 0 || tl > toplam) {
            sonucAlani.innerText = "Lütfen geçerli bir TL tutarı giriniz.";
            return;
        }

        const yuzde = (tl / toplam) * 100;
        const yeniFiyat = toplam - tl;

        sonucAlani.innerHTML = 
            `Uygulanan İndirim: %${yuzde.toFixed(2)}<br>
            İndirim Tutarı: ${tl.toFixed(2)} ₺<br>
            İndirimli Satış Fiyatı: ${yeniFiyat.toFixed(2)} ₺`;
    }

    function yuzdelikUygula() {
        const yuzde = parseFloat(document.getElementById("yuzdelikIndirim").value);
        const tlInput = document.getElementById("tlIndirim");

        if (!isNaN(yuzde)) {
            const satisFiyati = parseFloat(document.getElementById("satisFiyati").textContent);
            const indirimTutar = satisFiyati * (yuzde / 100);
            const yeniFiyat = satisFiyati - indirimTutar;
            document.getElementById("sonucAlani").innerHTML = 
                `<strong>İndirim: %${yuzde.toFixed(2)}</strong><br>
                Tutar: ${indirimTutar.toFixed(2)} ₺<br>
                Yeni Fiyat: ${yeniFiyat.toFixed(2)} ₺`;
            tlInput.value = '';
        } else {
            document.getElementById("sonucAlani").innerText = "Lütfen geçerli bir yüzde giriniz.";
        }
    }

    function tlUygula() {
        const tl = parseFloat(document.getElementById("tlIndirim").value);
        const yuzdeInput = document.getElementById("yuzdelikIndirim");

        if (!isNaN(tl)) {
            const satisFiyati = parseFloat(document.getElementById("satisFiyati").textContent);
            const yeniFiyat = satisFiyati - tl;
            document.getElementById("sonucAlani").innerHTML = 
                `<strong>İndirim: ${tl.toFixed(2)} ₺</strong><br>
                Yeni Fiyat: ${yeniFiyat.toFixed(2)} ₺`;
            yuzdeInput.value = '';
        } else {
            document.getElementById("sonucAlani").innerText = "Lütfen geçerli bir tutar giriniz.";
        }
    }
</script>

</body>
</html>

<?php $conn->close(); ?>
