<?php
include 'db.php';

$mesaj = "";

// Güncelleme işlemi varsa
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $yeni_oran = floatval($_POST['satis_fiyati_orani']);

    // 1. Ayarlar tablosunu güncelle
    $stmt = $conn->prepare("UPDATE ayarlar SET satis_fiyati_orani = ? WHERE id = 1");
    $stmt->bind_param("d", $yeni_oran);
    $stmt->execute();
    $stmt->close();

    // 2. Moduller tablosundaki tüm satış fiyatlarını güncelle
    $sql = "UPDATE moduller SET satis_fiyati = alis_fiyati * ?";
    $stmt2 = $conn->prepare($sql);
    $stmt2->bind_param("d", $yeni_oran);
    $stmt2->execute();
    $stmt2->close();

    // 3. Kullanıcıyı GET ile aynı sayfaya yönlendir (veri yeniden gönderilmesin)
    header("Location: fiyat_orani_guncelle.php?guncellendi=1");
    exit;
}

// Mevcut oranı veritabanından al
$result = $conn->query("SELECT satis_fiyati_orani FROM ayarlar WHERE id = 1");
$row = $result->fetch_assoc();
$mevcut_oran = $row['satis_fiyati_orani'];

// Başarılı güncelleme mesajı göster
if (isset($_GET['guncellendi']) && $_GET['guncellendi'] == 1) {
    $mesaj = "✅ Satış oranı başarıyla güncellendi ve tüm satış fiyatları yenilendi.";
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Satış Fiyat Oranı Güncelle</title>
    <style>
        body { font-family: Arial; margin: 40px; }
        label { font-weight: bold; }
        input { padding: 8px; width: 100px; margin-top: 5px; }
        button { padding: 10px 20px; margin-top: 10px; }
        .msg { margin-top: 20px; color: green; }
    </style>
</head>
<body>
    <h2>Satış Fiyat Oranı Güncelle</h2>

    <form method="POST">
        <label>Mevcut Oran:</label><br>
        <input type="number" name="satis_fiyati_orani" value="<?php echo htmlspecialchars($mevcut_oran); ?>" required step="0.01">
        <br>
        <button type="submit">Güncelle ve Tüm Satış Fiyatlarını Yenile</button>
    </form>

    <?php if (!empty($mesaj)) echo "<div class='msg'>$mesaj</div>"; ?>
     <div class="buton-container">
        <a href="urunler.php">Geri</a>
    </div>
</body>
</html>
