<?php

include 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $urun_id = $_POST['urun_id'];
    $modul_adi = $_POST['modul_adi'];
    $alis_fiyati = $_POST['alis_fiyati'];

    // Ayarlar tablosundan satış fiyatı oranını al
    $oran_sorgu = $conn->query("SELECT satis_fiyati_orani FROM ayarlar LIMIT 1");
    $oran_row = $oran_sorgu->fetch_assoc();
    $satis_fiyati_orani = $oran_row['satis_fiyati_orani'];

    // Alış fiyatını çarpan ile çarp ve satış fiyatını hesapla
    $satis_fiyati = $alis_fiyati * $satis_fiyati_orani;

    $gorsel = "";

    if (isset($_FILES['gorsel']) && $_FILES['gorsel']['error'] == 0) {
        $hedef_klasor = "modul_gorseller/";

        if (!is_dir($hedef_klasor)) {
            mkdir($hedef_klasor, 0777, true);
        }

        $gorsel = $hedef_klasor . basename($_FILES["gorsel"]["name"]);
        move_uploaded_file($_FILES["gorsel"]["tmp_name"], $gorsel);
    }

    $sql = "INSERT INTO moduller (urun_id, modul_adi, alis_fiyati, satis_fiyati, gorsel) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issds", $urun_id, $modul_adi, $alis_fiyati, $satis_fiyati, $gorsel);

    if ($stmt->execute()) {
        echo "✅ Modül başarıyla eklendi!";
        // Başarılı ekleme sonrası sayfayı yeniden yönlendir
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    } else {
        echo "❌ Hata: " . $stmt->error;
    }
}

// Tüm ürünlerin satış fiyatını güncellemek için
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['guncelle_oran'])) {
    $yeni_oran = $_POST['yeni_oran'];
    $conn->query("UPDATE ayarlar SET satis_fiyati_orani = $yeni_oran");

    // Tüm ürünlerin satış fiyatını güncelle
    $conn->query("UPDATE moduller SET satis_fiyati = alis_fiyati * $yeni_oran");
}

$urunler = $conn->query("SELECT id, urun_adi FROM urunler");

?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Modül Ekle</title>
    <style>
        body {
            font-family: Arial;
            padding: 20px;
            background-color: #f0f8ff;
        }
        form {
            background: #fff;
            padding: 20px;
            border-radius: 12px;
            max-width: 400px;
        }
    </style>
</head>
<body>
    <h1>Modül Ekle</h1>
    <form method="POST" enctype="multipart/form-data">
        <label for="urun_id">Ürün Seç:</label>
        <select name="urun_id" required>
            <?php while ($row = $urunler->fetch_assoc()): ?>
                <option value="<?= $row['id'] ?>"><?= $row['urun_adi'] ?></option>
            <?php endwhile; ?>
        </select><br><br>

        <label for="modul_adi">Modül Adı:</label>
        <input type="text" name="modul_adi" required><br><br>

        <label for="alis_fiyati">Alış Fiyatı:</label>
        <input type="number" name="alis_fiyati" step="0.01" required><br><br>

        <label for="gorsel">Görsel:</label>
        <input type="file" name="gorsel"><br><br>

        <input type="submit" value="Ekle">
    </form>

    
</body>
</html>
