<?php
include('db.php');

$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$sql = "SELECT * FROM urunler WHERE id = $product_id";
$result = $conn->query($sql);
$product = $result->fetch_assoc();

$modulSorgu = "SELECT * FROM moduller WHERE urun_id = $product_id";
$modulSonuc = $conn->query($modulSorgu);
?>

<!DOCTYPE html>
<html data-bs-theme="light" lang="en-US" dir="ltr">

  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">


    <!-- ===============================================-->
    <!--    Document Title-->
    <!-- ===============================================-->
    <title><?= htmlspecialchars($product['urun_adi']) ?> - Detay</title>

    <!-- ===============================================-->
    <!--    Favicons-->
    <!-- ===============================================-->
    <link rel="apple-touch-icon" sizes="180x180" href="../assets/img/favicons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="../assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="../assets/img/favicons/favicon-16x16.png">
    <link rel="shortcut icon" type="image/x-icon" href="../assets/img/favicons/favicon.ico">
    <link rel="manifest" href="../assets/img/favicons/manifest.json">
    <meta name="msapplication-TileImage" content="../assets/img/favicons/mstile-150x150.png">
    <meta name="theme-color" content="#ffffff">
    <script src="../assets/js/config.js"></script>
    <script src="../vendors/simplebar/simplebar.min.js"></script>


    <!-- ===============================================-->
    <!--    Stylesheets-->
    <!-- ===============================================-->
    <link href="../vendors/flatpickr/flatpickr.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700%7cPoppins:300,400,500,600,700,800,900&amp;display=swap" rel="stylesheet">
    <link href="../vendors/simplebar/simplebar.min.css" rel="stylesheet">
    <link href="../assets/css/theme-rtl.css" rel="stylesheet" id="style-rtl">
    <link href="../assets/css/theme.css" rel="stylesheet" id="style-default">
    <link href="../assets/css/user-rtl.css" rel="stylesheet" id="user-style-rtl">
    <link href="../assets/css/user.css" rel="stylesheet" id="user-style-default">
    <script>
      var isRTL = JSON.parse(localStorage.getItem('isRTL'));
      if (isRTL) {
        var linkDefault = document.getElementById('style-default');
        var userLinkDefault = document.getElementById('user-style-default');
        linkDefault.setAttribute('disabled', true);
        userLinkDefault.setAttribute('disabled', true);
        document.querySelector('html').setAttribute('dir', 'rtl');
      } else {
        var linkRTL = document.getElementById('style-rtl');
        var userLinkRTL = document.getElementById('user-style-rtl');
        linkRTL.setAttribute('disabled', true);
        userLinkRTL.setAttribute('disabled', true);
      }
    </script>
  </head>


  <body>

    <!-- ===============================================-->
    <!--    Main Content-->
    <!-- ===============================================-->
   <main class="main" id="top">
  <div class="container" data-layout="container">
    <script>
      var isFluid = JSON.parse(localStorage.getItem('isFluid'));
      if (isFluid) {
        var container = document.querySelector('[data-layout]');
        container.classList.remove('container');
        container.classList.add('container-fluid');
      }
    </script>

<div class="content mt-4">

    <!-- Ürün Adı ve Geri Butonu -->
    <div class="card shadow-none border">
        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
            <a href="index.php" class="text-white fs-4"><i class="fa fa-chevron-left"></i></a>
            <h3 class="mb-0"><?= htmlspecialchars($product['urun_adi'] ?? 'Ürün Bulunamadı') ?></h3>
            <span></span> <!-- Sağ boşluk için -->
        </div>
    </div>

  <!-- Fiyat Alanı -->
<div class="card shadow-none border mt-3">
    <div class="card-header z-1">
        <div class="row gx-0">
            <div class="col d-flex align-items-center">
                <h5 class="mb-0 text-primary fw-bold">Fiyat:</h5>
                <span id="toplamFiyat" class="ms-2 fw-bold text-success">0.00 ₺</span> <!-- Toplam fiyat burada gösterilecek -->
            </div>
        </div>
    </div>
</div>
    <!-- Tab Yapısı Başlangıç -->
    <div class="card overflow-hidden mt-3">
        <div class="card-header p-0 bg-body-tertiary scrollbar-overlay">
            <ul class="nav nav-tabs border-0 tab-tickets-status flex-nowrap" role="tablist">
                <li class="nav-item text-nowrap" role="presentation">
                    <a class="nav-link active d-flex align-items-center gap-2 py-3 px-x1" data-bs-toggle="tab" href="#modul-secimi" role="tab">
                        <span class="fas fa-mouse-pointer icon text-600"></span>
                        <h6 class="mb-0 text-600">Modül Seçimi</h6>
                    </a>
                </li>
                <li class="nav-item text-nowrap" role="presentation">
                    <a class="nav-link d-flex align-items-center gap-2 py-3 px-x1" data-bs-toggle="tab" href="#indirim" role="tab">
                        <span class="fas fa-percentage icon text-600"></span>
                        <h6 class="mb-0 text-600">İndirim</h6>
                    </a>
                </li>
            </ul>
        </div>

        <div class="card-body p-4">
            <div class="tab-content">

                <!-- MODÜL SEÇİMİ -->
                <div class="tab-pane fade show active" id="modul-secimi" role="tabpanel">
                    <div class="row g-4">

                        <!-- Sol Kısım: Modül Seçimi -->
                        <div class="col-12 col-lg-7">
                            <h5 class="text-primary mb-3">Modül Seçimi</h5>
                            <?php while($modul = $modulSonuc->fetch_assoc()): ?>
                                <div class="border-bottom pb-3 mb-4">
                                    <h6 class="fw-semibold"><?= htmlspecialchars($modul['modul_adi']) ?></h6>
                                    <div class="input-group mb-2">
                                        <input type="number" id="adet_<?= $modul['id'] ?>" class="form-control" placeholder="Adet" min="1">
                                        <button class="btn btn-success" onclick="modulEkle(<?= $modul['id'] ?>, '<?= htmlspecialchars($modul['gorsel']) ?>', <?= $modul['satis_fiyati'] ?>, <?= $modul['alis_fiyati'] ?>, '<?= htmlspecialchars($modul['modul_adi']) ?>')">Ekle</button>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>

                        <!-- Sağ Kısım: Seçilen Modüller -->
                        <div class="col-12 col-lg-5">
                            <h5 class="text-info mb-3">Seçilen Modüller</h5>
                            <div id="seciliModuller" class="p-3 mb-4 bg-light rounded shadow-sm text-center" style="min-height: 100px;">
                                Henüz modül seçilmedi.
                            </div>
                        </div>

                    </div>
                </div>

                <!-- İNDİRİM -->
                <div class="tab-pane fade" id="indirim" role="tabpanel">
                    <div class="row g-4">

                        <!-- Sol Kısım: Yüzdelik İndirim -->
                        <div class="col-12 col-lg-6">
                            <h6 class="text-warning mb-3">Yüzdelik İndirim</h6>
                            <input type="number" id="modulYuzdeIndirim" class="form-control mb-2" placeholder="% Yüzdelik İndirim">
                            <button class="btn btn-outline-primary w-100 mb-3" onclick="modulYuzdeIndirimUygula()">Yüzdelik İndirim Uygula</button>
                        </div>

                        <!-- Sağ Kısım: TL İndirim -->
                        <div class="col-12 col-lg-6">
                            <h6 class="text-warning mb-3">TL İndirim</h6>
                            <input type="number" id="modulTlIndirim" class="form-control mb-2" placeholder="₺ TL İndirim">
                            <button class="btn btn-outline-primary w-100 mb-3" onclick="modulTlIndirimUygula()">TL İndirim Uygula</button>
                        </div>

                        <div class="col-12">
                            <div id="modulIndirimSonuc" class="fw-bold text-dark mt-3 text-center"></div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Footer Buton -->
    <div class="card-footer text-center mt-3">
        <a href="index.php" class="btn btn-secondary">← Ürün Listesine Geri Dön</a>
    </div>

</div>
</div>
</main>

<script>
const secilenler = {};
let uygulananIndirimTutar = 0;

function modulEkle(id, gorsel, fiyat, alisFiyati, modulAdi) {
    const adetInput = document.getElementById('adet_' + id);
    const adet = parseInt(adetInput.value);
    if (!adet || adet <= 0) {
        alert("Lütfen geçerli bir adet giriniz.");
        return;
    }

    if (secilenler[id]) {
        secilenler[id].adet += adet;
    } else {
        secilenler[id] = {
            gorsel: gorsel,
            fiyat: fiyat,
            alisFiyati: alisFiyati,
            adet: adet,
            modulAdi: modulAdi
        };
    }

    adetInput.value = '';
    uygulananIndirimTutar = 0; // Yeni modül eklenince indirimi sıfırla
    renderSecilenler();
}

function renderSecilenler() {
    const container = document.getElementById('seciliModuller');
    container.innerHTML = '';

    let toplamTutar = 0;
    let toplamAlisFiyati = 0;

    for (let id in secilenler) {
        const modul = secilenler[id];
        const urunToplam = modul.fiyat * modul.adet;
        const alisToplam = modul.alisFiyati * modul.adet;
        toplamTutar += urunToplam;
        toplamAlisFiyati += alisToplam;

        const div = document.createElement('div');
        div.classList.add('secilen-modul');
        div.innerHTML = 
            `<h4>${modul.modulAdi}</h4>
            <p><strong>Fiyat:</strong> ${modul.fiyat.toFixed(2)} ₺ x ${modul.adet} = <strong>${urunToplam.toFixed(2)} ₺</strong></p>
            <button class="btn btn-danger btn-sm" onclick="modulSil(${id})"><i class="fa fa-trash"></i></button>`;
        container.appendChild(div);
    }

    if (toplamTutar === 0) {
        container.innerText = 'Henüz modül seçilmedi.';
        document.getElementById('toplamFiyat').innerHTML = '0.00 ₺'; // Toplam fiyatı sıfırla
        document.getElementById('modulIndirimSonuc').innerHTML = ''; // İndirim sonucunu temizle
    } else {
        const toplamDiv = document.createElement('div');
        toplamDiv.style.marginTop = '15px';
        toplamDiv.innerHTML = `<strong>Toplam Tutar: ${toplamTutar.toFixed(2)} ₺</strong>`;
        container.appendChild(toplamDiv);

        let karMarji = Math.round(toplamTutar - toplamAlisFiyati - uygulananIndirimTutar); // Yuvarlama işlemi
        const karMarjiDiv = document.createElement('div');
        karMarjiDiv.style.marginTop = '15px';

        // Toplam alış fiyatının 1.1 ile çarpılması
        const toplamAlisFiyatiCarpim = Math.round(toplamAlisFiyati * 1.1); // Tam sayı olarak al

        if (karMarji < 0) {
            karMarjiDiv.innerHTML = `<strong>İşlem Kodu: HATA</strong>`;
        } else {
            karMarjiDiv.innerHTML = `<strong>İşlem Kodu: LORA${karMarji}-GTXGY-${toplamAlisFiyatiCarpim}-LORA</strong>`;
        }

        container.appendChild(karMarjiDiv);

        // Toplam fiyat alanında işlem kodunu göster
        document.getElementById('toplamFiyat').innerHTML = 
            `${toplamTutar.toFixed(2)} ₺ - <strong>${karMarjiDiv.innerHTML}</strong>`; // Toplam fiyatı güncelle
    }
}

function modulSil(id) {
    delete secilenler[id]; // Seçilen modülü sil
    renderSecilenler(); // Güncellenmiş durumu yeniden render et
}

function modulYuzdeIndirimUygula() {
    const yuzde = parseFloat(document.getElementById("modulYuzdeIndirim").value);
    const sonucAlani = document.getElementById("modulIndirimSonuc");

    let toplam = 0;
    for (let id in secilenler) {
        toplam += secilenler[id].fiyat * secilenler[id].adet;
    }

    if (isNaN(yuzde) || yuzde < 0) {
        sonucAlani.innerText = "Lütfen geçerli bir yüzde giriniz.";
        return;
    }

    const indirimTutar = toplam * (yuzde / 100);
    uygulananIndirimTutar = indirimTutar;
    const yeniFiyat = toplam - indirimTutar;

    sonucAlani.innerHTML = 
        `Uygulanan İndirim: %${yuzde.toFixed(2)}<br>
        İndirim Tutarı: ${indirimTutar.toFixed(2)} ₺<br>
        İndirimli Satış Fiyatı: ${yeniFiyat.toFixed(2)} ₺`;

    renderSecilenler();
}

function modulTlIndirimUygula() {
    const tl = parseFloat(document.getElementById("modulTlIndirim").value);
    const sonucAlani = document.getElementById("modulIndirimSonuc");

    let toplam = 0;
    for (let id in secilenler) {
        toplam += secilenler[id].fiyat * secilenler[id].adet;
    }

    if (isNaN(tl) || tl < 0 || tl > toplam) {
        sonucAlani.innerText = "Lütfen geçerli bir TL tutarı giriniz.";
        return;
    }

    uygulananIndirimTutar = tl;
    const yuzde = (tl / toplam) * 100;
    const yeniFiyat = toplam - tl;

    sonucAlani.innerHTML = 
        `Uygulanan İndirim: %${yuzde.toFixed(2)}<br>
        İndirim Tutarı: ${tl.toFixed(2)} ₺<br>
        İndirimli Satış Fiyatı: ${yeniFiyat.toFixed(2)} ₺`;

    renderSecilenler();
}
</script>

    <!-- ===============================================-->
    <!--    End of Main Content-->
    <!-- ===============================================-->





    <!-- ===============================================-->
    <!--    JavaScripts-->
    <!-- ===============================================-->
    <script src="../vendors/popper/popper.min.js"></script>
    <script src="../vendors/bootstrap/bootstrap.min.js"></script>
    <script src="../vendors/anchorjs/anchor.min.js"></script>
    <script src="../vendors/is/is.min.js"></script>
    <script src="../vendors/echarts/echarts.min.js"></script>
    <script src="../vendors/dayjs/dayjs.min.js"></script>
    <script src="../vendors/flatpickr/flatpickr.min.js"></script>
    <script src="../vendors/fontawesome/all.min.js"></script>
    <script src="../vendors/lodash/lodash.min.js"></script>
    <script src="../vendors/list.js/list.min.js"></script>
    <script src="../assets/js/theme.js"></script>

  </body>

</html>


<?php $conn->close(); ?>