<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Ürünler</title>
    <style>
        body { font-family: Arial; margin: 30px; position: relative; }
        input { padding: 8px; width: 300px; margin-bottom: 15px; }
        ul { list-style: none; padding: 0; margin-top: 10px; }
        li { padding: 8px; border-bottom: 1px solid #ccc; }
        a { text-decoration: none; color: #333; }
        a:hover { text-decoration: underline; }

        .buton-container {
            position: absolute;
            top: 30px;
            right: 30px;
        }

        .buton-container a {
            background-color: #007BFF;
            color: white;
            padding: 10px 16px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 14px;
        }

        .buton-container a:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="buton-container">
        <a href="fiyat_orani_guncelle.php">Fiyat Oranı Güncelle</a>
    </div>

    <h2>Ürünler</h2>
    <input type="text" id="arama" placeholder="Ürün adı yaz...">
    <ul id="sonuclar">
        <?php
        $sql = "SELECT * FROM urunler ORDER BY urun_adi ASC";
        $result = $conn->query($sql);

        while ($urun = $result->fetch_assoc()) {
            echo "<li><a href='moduller.php?urun_id=" . $urun['id'] . "'>" . htmlspecialchars($urun['urun_adi']) . "</a></li>";
        }
        ?>
    </ul>

    <script>
        document.getElementById("arama").addEventListener("keyup", function () {
            var kelime = this.value;

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "urun_ara.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

            xhr.onload = function () {
                if (xhr.status === 200) {
                    document.getElementById("sonuclar").innerHTML = xhr.responseText;
                }
            };

            xhr.send("kelime=" + encodeURIComponent(kelime));
        });
    </script>
</body>
</html>
