<?php
include 'db.php'; // Veritabanı bağlantısını içeren dosya

session_start();

// İşletme ID'sini kontrol et
if (!isset($_SESSION['isletme_id'])) {
    header("Location: giris.php");
    exit();
}

$isletme_id = $_SESSION['isletme_id'];

// Tüm personelleri çek
$sql = "SELECT id, personel_ad, personel_soyad, personel_mail FROM personeller WHERE isletme_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $isletme_id);
$stmt->execute();
$stmt->store_result(); // Sonuçları depola

// Sonuçları almak için bind_result kullan
$stmt->bind_result($id, $personel_ad, $personel_soyad, $personel_mail);

$personeller = [];
while ($stmt->fetch()) {
    $personeller[] = [
        'id' => $id,
        'personel_ad' => $personel_ad,
        'personel_soyad' => $personel_soyad,
        'personel_mail' => $personel_mail,
    ];
}

// Bildirim gönderme
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['gonder'])) {
    $aciklama = $_POST['aciklama'];
    $selected_personeller = $_POST['personeller']; // Seçilen personeller

    foreach ($selected_personeller as $personel_id) {
        // Bildirim kaydet
        $insert_sql = "INSERT INTO bildirimler (isletme_id, personel_id, aciklama) VALUES (?, ?, ?)";
        $insert_stmt = $conn->prepare($insert_sql);
        $insert_stmt->bind_param("iis", $isletme_id, $personel_id, $aciklama);
        $insert_stmt->execute();
    }

    // Bildirim gönderiminden sonra sayfayı yenile
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}
?>
<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <meta name="description" content="">
        <meta name="author" content="Tooplate">

        <title>ENPDKS</title>

        <!-- CSS FILES -->      
        <link rel="preconnect" href="https://fonts.googleapis.com">
        
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

        <link href="https://fonts.googleapis.com/css2?family=Unbounded:wght@300;400;700&display=swap" rel="stylesheet">

        <link href="css/bootstrap.min.css" rel="stylesheet">

        <link href="css/bootstrap-icons.css" rel="stylesheet">

        <link href="css/apexcharts.css" rel="stylesheet">

        <link href="css/tooplate-mini-finance.css" rel="stylesheet">
<!--

Tooplate 2135 Mini Finance

https://www.tooplate.com/view/2135-mini-finance

Bootstrap 5 Dashboard Admin Template

-->

    </head>
    
    <body>
        <header class="navbar sticky-top flex-md-nowrap">
            <div class="col-md-3 col-lg-3 me-0 px-3 fs-6">
                <a class="navbar-brand" href="panel.php">
                    <i class="bi-box"></i>
                    ENPDKS
                </a>
            </div>

            <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <form class="custom-form header-form ms-lg-3 ms-md-3 me-lg-auto me-md-auto order-2 order-lg-0 order-md-0" action="#" method="get" role="form">
                <input class="form-control" name="search" type="text" placeholder="Search" aria-label="Search">
            </form>

            <div class="navbar-nav me-lg-2">
                <div class="nav-item text-nowrap d-flex align-items-center">
                    <div class="dropdown ps-3">
                        <a class="nav-link dropdown-toggle text-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" id="navbarLightDropdownMenuLink">
                            <i class="bi-bell"></i>
                            <span class="position-absolute start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
                                <span class="visually-hidden">New alerts</span>
                            </span>
                        </a>

                        <ul class="dropdown-menu dropdown-menu-lg-end notifications-block-wrap bg-white shadow" aria-labelledby="navbarLightDropdownMenuLink">
                            <small>Bildirimler</small>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex  align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-success">
                                        <i class="notifications-icon bi-check-circle-fill"></i>
                                    </div>

                                    <div>
                                        <span>Your account has been created successfuly.</span>

                                        <p>12 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-info">
                                        <i class="notifications-icon bi-folder"></i>
                                    </div>

                                    <div>
                                        <span>Please check. We have sent a Daily report.</span>

                                        <p>10 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-danger">
                                        <i class="notifications-icon bi-question-circle"></i>
                                    </div>

                                    <div>
                                        <span>Account verification failed.</span>

                                        <p>1 hour ago</p>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>

              

                    <div class="dropdown px-3">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid" alt="">
                        </a>
                        <ul class="dropdown-menu bg-white shadow">
                            <li>
                                <div class="dropdown-menu-profile-thumb d-flex">
                                    <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid me-3" alt="">

                                    <div class="d-flex flex-column">
                                        <small>Thomas</small>
                                        <a href="#">thomas@site.com</a>
                                    </div>
                                </div>
                            </li>

                            <li>
                                <a class="dropdown-item" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profil
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Ayarlar
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Yardım
                                </a>
                            </li>

                            <li class="border-top mt-3 pt-2 mx-4">
                                <a class="dropdown-item ms-0 me-0" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Çıkış Yap
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </header>

        <div class="container-fluid">
            <div class="row">
                <nav id="sidebarMenu" class="col-md-3 col-lg-3 d-md-block sidebar collapse">
                    <div class="position-sticky py-4 px-3 sidebar-sticky">
                        <ul class="nav flex-column h-100">
                            <li class="nav-item">
                                <a class="nav-link " aria-current="page" href="panel.php">
                                    <i class="bi-house-fill me-2"></i>
                                    Ana Ekran
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a class="nav-link" href="personel_kayit.php">
                                    Personel Kayıt
                                </a>
                            </li>
                            
                                <li class="nav-item">
                                <a class="nav-link " href="personel_liste.php">
                                    Personel Listesi
                                </a>
                            </li>
                              <li class="nav-item">
                                <a class="nav-link " href="konum.php">
                                    Konum İşlemleri
                                </a>
                            </li>
                              <li class="nav-item">
                                <a class="nav-link active " href="bildirim.php">
                                    Bildirim Gönder
                                </a>
                            </li>
                             <li class="nav-item">
                                <a class="nav-link " href="bildirim_liste.php">
                                    Bildirim Listesi
                                </a>
                            </li>
 <ul class="nav">
        <li class="nav-item">
            <a class="nav-link " onclick="toggleSubMenu()">Etiket İşlemleri</a>
            <div class="sub-menu">
                <p><a href="etiket_ekle.php">Grup Ekle</a></p>
                <p><a href="etiketler.php">Grupları Listele</a></p>
            </div>
        </li>
    </ul>

 <a class="nav-link" href="isletme_ayarlari.php">
                                    <i class="bi-gear me-2"></i>
                                    İşletme Ayarları
                                </a>
                            </li>


                            <li class="nav-item">
                                <a class="nav-link" href="wallet.html">
                                    <i class="bi-wallet me-2"></i>
                                    My Wallet
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profile
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Settings
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Help Center
                                </a>
                            </li>

                            <li class="nav-item featured-box mt-lg-5 mt-4 mb-4">
                                <img src="images/credit-card.png" class="img-fluid" alt="">

                                <a class="btn custom-btn" href="#">Upgrade</a>
                            </li>

                            <li class="nav-item border-top mt-auto pt-2">
                                <a class="nav-link" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </nav>
                  <style>
           .sub-menu {
            display: none;
            margin-left: 20px;
        }
        .nav-link {
            cursor: pointer;
        }
        .sub-menu p {
            color: black; /* Paragrafların rengi siyah */
            margin: 0; /* Varsayılan margin'i sıfırlamak için */
        }
    </style>
    
     <script>
        function toggleSubMenu() {
            const subMenu = document.querySelector('.sub-menu');
            subMenu.style.display = subMenu.style.display === 'none' || subMenu.style.display === '' ? 'block' : 'none';
        }
    </script>

<!-- HTML Kısmı -->
<main class="main-wrapper col-md-9 ms-sm-auto py-4 col-lg-9 px-md-4 border-start">
    <div class="title-group mb-3">
        <h1 class="h2 mb-0">Bildirim Gönder</h1>
    </div>

    <form method="POST">
        <label for="aciklama">Bildirim İçeriği:</label>
        <textarea name="aciklama" required></textarea><br>

        <h6>Personeller:</h6>
        <button type="button" id="select-all" class="btn btn-primary mb-2">Tümünü Seç</button>
        <button type="button" id="deselect-all" class="btn btn-secondary mb-2">Seçimi Kaldır</button>
        
        <div class="table-responsive">
            <table class="account-table table">
                <tbody>
                    <?php foreach ($personeller as $personel): ?>
                        <tr>
                            <td>
                                <input type="checkbox" name="personeller[]" value="<?php echo $personel['id']; ?>" class="select-checkbox">
                            </td>
                            <td><?php echo htmlspecialchars($personel['personel_ad'] . ' ' . $personel['personel_soyad']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <button type="submit" name="gonder" class="btn btn-success">Gönder</button>
    </form>
</main>

<script>
    document.getElementById('select-all').addEventListener('click', function() {
        const checkboxes = document.querySelectorAll('.select-checkbox');
        checkboxes.forEach(checkbox => checkbox.checked = true);
    });

    document.getElementById('deselect-all').addEventListener('click', function() {
        const checkboxes = document.querySelectorAll('.select-checkbox');
        checkboxes.forEach(checkbox => checkbox.checked = false);
    });
</script>
