<?php
session_start();
include 'db.php';
include 'phpqrcode/qrlib.php'; // QR kod kütüphanesini dahil ediyoruz

// Kullanıcı giriş yapmamışsa yönlendir
if (!isset($_SESSION['isletme_id'])) {
    header("Location: yonetici_giris.php");
    exit();
}

$isletme_id = $_SESSION['isletme_id'];  // Oturumdaki işletme ID'sini alıyoruz
$success = "";
$error = "";

// İşletme ID'sinin veritabanında geçerli olup olmadığını kontrol ediyoruz
$sql_check_isletme = "SELECT id FROM isletmeler WHERE id = ?";
$stmt_check_isletme = $conn->prepare($sql_check_isletme);
if ($stmt_check_isletme === false) {
    die('Prepare failed: ' . htmlspecialchars($conn->error));
}
$stmt_check_isletme->bind_param("i", $isletme_id);
$stmt_check_isletme->execute();
$stmt_check_isletme->store_result();

// Eğer işletme bulunamazsa, hata mesajı gösteriyoruz
if ($stmt_check_isletme->num_rows == 0) {
    $error = "Geçerli bir işletme bulunamadı!";
} else {
    // Veritabanı geçerli işletme ID'si var ise form gönderildiğinde konum ekleme işlemini gerçekleştiriyoruz
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        if (isset($_POST['ekle'])) {
            $konum_ad = $_POST['konum_ad'];
            $konum_alani = $_POST['konum_alani'];
            $konum_disi_okutma = $_POST['konum_disi_okutma']; // 1 veya 0
            $aktif = $_POST['aktif'];  // 1 aktif, 0 değil

            // QR kod oluşturma
            $qr_data = "Konum: " . $konum_ad . " - " . $konum_alani . "m²"; // QR kodu için veri
            $qr_code_file = "qr_codes/" . uniqid() . ".png";  // QR kod dosyasının ismi
            QRcode::png($qr_data, $qr_code_file); // QR kodu oluşturuyoruz

            // Konum ekleme
            $sql = "INSERT INTO konumlar (isletme_id, konum_ad, konum_alani, konum_disi_okutma, aktif, qr_kod) 
                    VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            if ($stmt === false) {
                die('Prepare failed: ' . htmlspecialchars($conn->error));
            }
            $stmt->bind_param("isssis", $isletme_id, $konum_ad, $konum_alani, $konum_disi_okutma, $aktif, $qr_code_file);

            if ($stmt->execute()) {
                $success = "Konum başarıyla eklendi.";
                // Form gönderiminden sonra yönlendirme yap
                header("Location: " . $_SERVER['PHP_SELF']);
                exit();
            } else {
                $error = "Kayıt eklenirken hata oluştu: " . $stmt->error;
            }
        }

        // Aktif durumu değiştirme
        if (isset($_POST['toggle_active'])) {
            $konum_id = $_POST['toggle_active'];
            $sql_toggle = "UPDATE konumlar SET aktif = NOT aktif WHERE id = ?";
            $stmt_toggle = $conn->prepare($sql_toggle);
            if ($stmt_toggle === false) {
                die('Prepare failed: ' . htmlspecialchars($conn->error));
            }
            $stmt_toggle->bind_param("i", $konum_id);
            $stmt_toggle->execute();
        }

        // Konum silme işlemi
        if (isset($_POST['sil'])) {
            $konum_id = $_POST['sil'];
            $sql_delete = "DELETE FROM konumlar WHERE id = ?";
            $stmt_delete = $conn->prepare($sql_delete);
            if ($stmt_delete === false) {
                die('Prepare failed: ' . htmlspecialchars($conn->error));
            }
            $stmt_delete->bind_param("i", $konum_id);
            $stmt_delete->execute();
        }
    }
}

// Konumları veritabanından çekiyoruz
$sql_get_konumlar = "SELECT * FROM konumlar WHERE isletme_id = ?";
$stmt_get_konumlar = $conn->prepare($sql_get_konumlar);
if ($stmt_get_konumlar === false) {
    die('Prepare failed: ' . htmlspecialchars($conn->error));
}
$stmt_get_konumlar->bind_param("i", $isletme_id);
$stmt_get_konumlar->execute();
$stmt_get_konumlar->store_result(); // Sonuçları depoluyoruz

// Sonuçları almak için değişkenleri tanımlıyoruz
$stmt_get_konumlar->bind_result($id, $isletme_id, $konum_ad, $konum_alani, $konum_disi_okutma, $aktif, $qr_kod);
?>

<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <meta name="description" content="">
        <meta name="author" content="Tooplate">

        <title>ENPDKS</title>

        <!-- CSS FILES -->      
        <link rel="preconnect" href="https://fonts.googleapis.com">
        
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

        <link href="https://fonts.googleapis.com/css2?family=Unbounded:wght@300;400;700&display=swap" rel="stylesheet">

        <link href="css/bootstrap.min.css" rel="stylesheet">

        <link href="css/bootstrap-icons.css" rel="stylesheet">

        <link href="css/apexcharts.css" rel="stylesheet">

        <link href="css/tooplate-mini-finance.css" rel="stylesheet">
<!--

Tooplate 2135 Mini Finance

https://www.tooplate.com/view/2135-mini-finance

Bootstrap 5 Dashboard Admin Template

-->

    </head>
    
    <body>
        <header class="navbar sticky-top flex-md-nowrap">
            <div class="col-md-3 col-lg-3 me-0 px-3 fs-6">
                <a class="navbar-brand" href="panel.php">
                    <i class="bi-box"></i>
                    ENPDKS
                </a>
            </div>

            <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <form class="custom-form header-form ms-lg-3 ms-md-3 me-lg-auto me-md-auto order-2 order-lg-0 order-md-0" action="#" method="get" role="form">
                <input class="form-control" name="search" type="text" placeholder="Search" aria-label="Search">
            </form>

            <div class="navbar-nav me-lg-2">
                <div class="nav-item text-nowrap d-flex align-items-center">
                    <div class="dropdown ps-3">
                        <a class="nav-link dropdown-toggle text-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" id="navbarLightDropdownMenuLink">
                            <i class="bi-bell"></i>
                            <span class="position-absolute start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
                                <span class="visually-hidden">New alerts</span>
                            </span>
                        </a>

                        <ul class="dropdown-menu dropdown-menu-lg-end notifications-block-wrap bg-white shadow" aria-labelledby="navbarLightDropdownMenuLink">
                            <small>Bildirimler</small>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex  align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-success">
                                        <i class="notifications-icon bi-check-circle-fill"></i>
                                    </div>

                                    <div>
                                        <span>Your account has been created successfuly.</span>

                                        <p>12 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-info">
                                        <i class="notifications-icon bi-folder"></i>
                                    </div>

                                    <div>
                                        <span>Please check. We have sent a Daily report.</span>

                                        <p>10 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-danger">
                                        <i class="notifications-icon bi-question-circle"></i>
                                    </div>

                                    <div>
                                        <span>Account verification failed.</span>

                                        <p>1 hour ago</p>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>

              

                    <div class="dropdown px-3">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid" alt="">
                        </a>
                        <ul class="dropdown-menu bg-white shadow">
                            <li>
                                <div class="dropdown-menu-profile-thumb d-flex">
                                    <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid me-3" alt="">

                                    <div class="d-flex flex-column">
                                        <small>Thomas</small>
                                        <a href="#">thomas@site.com</a>
                                    </div>
                                </div>
                            </li>

                            <li>
                                <a class="dropdown-item" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profil
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Ayarlar
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Yardım
                                </a>
                            </li>

                            <li class="border-top mt-3 pt-2 mx-4">
                                <a class="dropdown-item ms-0 me-0" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Çıkış Yap
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </header>


        <div class="container-fluid">
            <div class="row">
                <nav id="sidebarMenu" class="col-md-3 col-lg-3 d-md-block sidebar collapse">
                    <div class="position-sticky py-4 px-3 sidebar-sticky">
                        <ul class="nav flex-column h-100">
                            <li class="nav-item">
                                <a class="nav-link " aria-current="page" href="panel.php">
                                    <i class="bi-house-fill me-2"></i>
                                    Ana Ekran
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a class="nav-link" href="personel_kayit.php">
                                    Personel Kayıt
                                </a>
                            </li>
                            
                                <li class="nav-item">
                                <a class="nav-link " href="personel_liste.php">
                                    Personel Listesi
                                </a>
                            </li>
                              <li class="nav-item">
                                <a class="nav-link active " href="konum.php">
                                    Konum İşlemleri
                                </a>
                            </li>
                             <li class="nav-item">
                                <a class="nav-link " href="bildirim.php">
                                    Bildirim Gönder
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link " href="bildirim_liste.php">
                                    Bildirim Listesi
                                </a>
                            </li>
 <ul class="nav">
        <li class="nav-item">
            <a class="nav-link " onclick="toggleSubMenu()">Grup İşlemleri</a>
            <div class="sub-menu">
                <p><a href="etiket_ekle.php">Grup Ekle</a></p>
                <p><a href="etiketler.php">Grupları Listele</a></p>
            </div>
        </li>
    </ul>
 <a class="nav-link" href="isletme_ayarlari.php">
                                    <i class="bi-gear me-2"></i>
                                    İşletme Ayarları
                                </a>
                            </li>



                            <li class="nav-item">
                                <a class="nav-link" href="wallet.html">
                                    <i class="bi-wallet me-2"></i>
                                    My Wallet
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profile
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Settings
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Help Center
                                </a>
                            </li>

                            <li class="nav-item featured-box mt-lg-5 mt-4 mb-4">
                                <img src="images/credit-card.png" class="img-fluid" alt="">

                                <a class="btn custom-btn" href="#">Upgrade</a>
                            </li>

                            <li class="nav-item border-top mt-auto pt-2">
                                <a class="nav-link" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </nav>
                  <style>
           .sub-menu {
            display: none;
            margin-left: 20px;
        }
        .nav-link {
            cursor: pointer;
        }
        .sub-menu p {
            color: black; /* Paragrafların rengi siyah */
            margin: 0; /* Varsayılan margin'i sıfırlamak için */
        }
    </style>
    
     <script>
        function toggleSubMenu() {
            const subMenu = document.querySelector('.sub-menu');
            subMenu.style.display = subMenu.style.display === 'none' || subMenu.style.display === '' ? 'block' : 'none';
        }
    </script>

        <div class="navbar-nav me-lg-2">
            <div class="nav-item text-nowrap d-flex align-items-center">
                <div class="dropdown ps-3">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid" alt="">
                    </a>
                    <ul class="dropdown-menu bg-white shadow">
                        <li>
                            <div class="dropdown-menu-profile-thumb d-flex">
                                <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid me-3" alt="">
                                <div class="d-flex flex-column">
                                    <small><?php echo htmlspecialchars($_SESSION['isletme_id']); ?></small>
                                </div>
                            </div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bi-box-arrow-left me-2"></i>
                                Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </header>

    <div class="container-fluid">
        <div class="row">
            <main class="main-wrapper col-md-9 ms-sm-auto py-4 col-lg-9 px-md-4 border-start">
                <div class="title-group mb-3">
                    <h1 class="h2 mb-0">Konum İşlemleri</h1>
                </div>

                <h6 class="mb-4">Konum Ekle</h6>
                <form class="custom-form profile-form" action="#" method="post" role="form">
                    <input class="form-control" type="text" name="konum_ad" id="konum_ad" placeholder="Konum Adı" required>
                    <input class="form-control" type="text" name="konum_alani" id="konum_alani" placeholder="Konum Alanı (m²)" required>
                   
                    <div class="input-group mb-1">
                        <label for="konum_disi_okutma" class="me-2">Konum Dışı Okuma:</label>
                        <select name="konum_disi_okutma" id="konum_disi_okutma" class="form-control">
                            <option value="1">Evet</option>
                            <option value="0">Hayır</option>
                        </select>
                    </div>
                    <div class="input-group mb-1">
                        <label for="aktif" class="me-2">Aktif:</label>
                        <select name="aktif" id="aktif" class="form-control">
                            <option value="1">Evet</option>
                            <option value="0">Hayır</option>
                        </select>
                    </div>
                    <div class="d-flex">
                        <button type="button" class="form-control me-3">Temizle</button>
                        <button type="submit" name="ekle" class="form-control ms-2">Ekle</button>
                    </div>
                </form>

                <h5 class="mb-4">Eklenen Konumlar</h5>
                <div class="table-responsive">
                    <table class="account-table table">
                        <thead>
                            <tr>
                                <th scope="col">Konum Adı</th>
                                <th scope="col">Konum Alanı (m²)</th>
                               
                                <th scope="col">Dış Okuma</th>
                                <th scope="col">Aktif</th>
                                <th scope="col">QR Kod</th>
                                <th scope="col">İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($stmt_get_konumlar->num_rows > 0): ?>
                                <?php while ($stmt_get_konumlar->fetch()): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($konum_ad); ?></td>
                                        <td><?php echo htmlspecialchars($konum_alani); ?></td>
                                        
                                        <td><?php echo htmlspecialchars($konum_disi_okutma == 1 ? 'Evet' : 'Hayır'); ?></td>
                                        <td>
                                            <form method="POST" style="display:inline;">
                                                <button type="submit" name="toggle_active" value="<?php echo $id; ?>">
                                                    <?php echo ($aktif == 1) ? 'Pasif Yap' : 'Aktif Yap'; ?>
                                                </button>
                                            </form>
                                        </td>
                                        <td>
                                            <img src="<?php echo htmlspecialchars($qr_kod); ?>" alt="QR Kod" style="width: 50px; height: 50px;">
                                            <a href="<?php echo htmlspecialchars($qr_kod); ?>" download>
                                                <button>İndir</button>
                                            </a>
                                        </td>
                                        <td>
                                            <form method="POST" style="display:inline;">
                                                <button type="submit" name="sil" value="<?php echo $id; ?>" onclick="return confirm('Bu konumu silmek istediğinize emin misiniz?');">Sil</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7">Henüz eklenmiş bir konum yok.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <?php
    $stmt_get_konumlar->close();
    $stmt_check_isletme->close();
    $conn->close();
    ?>
</body>
</html>
