<?php
session_start();
include 'db.php'; // Veritabanı bağlantısı

// Kullanıcı giriş yapmamışsa yönlendir
if (!isset($_SESSION['isletme_id'])) {
    header("Location: yonetici_giris.php");
    exit();
}

$isletme_id = $_SESSION['isletme_id'];
$success = "";
$error = "";

// Konumları çekme
$konum_sql = "SELECT id, konum_ad FROM konumlar WHERE isletme_id = ?";
$konum_stmt = $conn->prepare($konum_sql);
$konum_stmt->bind_param("i", $isletme_id);
$konum_stmt->execute();
$konum_stmt->store_result();
$konum_stmt->bind_result($konum_id, $konum_ad);
$konumlar = [];

while ($konum_stmt->fetch()) {
    $konumlar[] = ['id' => $konum_id, 'ad' => $konum_ad];
}

// Form gönderimi kontrolü
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Personel Ekleme
    if (isset($_POST['personel_ad'])) {
        $personel_ad = $_POST['personel_ad'];
        $personel_soyad = $_POST['personel_soyad'];
        $personel_numara = $_POST['personel_numara'];
        $personel_mail = $_POST['personel_mail'];
        $personel_sifre = password_hash($_POST['personel_sifre'], PASSWORD_BCRYPT);
        $etiket = ""; // Etiket boş kalacak
        $personel_statusu = 2; // Personel için statusu 2
        $konum_id = $_POST['konum_id']; // Konum ID'sini al

        // Telefon numarası veya e-posta zaten var mı kontrol et
        $check_sql = "SELECT id FROM personeller WHERE personel_numara = ? OR personel_mail = ?";
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("ss", $personel_numara, $personel_mail);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            $error = "Bu telefon numarası veya e-posta zaten kayıtlı!";
        } else {
            // Personel ekleme
            $sql = "INSERT INTO personeller (isletme_id, personel_ad, personel_soyad, personel_numara, personel_mail, personel_sifre, etiket, personel_statusu, konum_id) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("issssssii", $isletme_id, $personel_ad, $personel_soyad, $personel_numara, $personel_mail, $personel_sifre, $etiket, $personel_statusu, $konum_id);

            if ($stmt->execute()) {
                $success = "Personel başarıyla eklendi.";
                // Başarı ile kayıt sonrası yönlendirme
                header("Location: personel_kayit.php?success=" . urlencode($success));
                exit();
            } else {
                $error = "Kayıt eklenirken hata oluştu: " . $stmt->error;
            }
        }
    }

    // Yönetici Ekleme
    if (isset($_POST['yönetici_ad'])) {
        $yönetici_ad = $_POST['yönetici_ad'];
        $yönetici_soyad = $_POST['yönetici_soyad'];
        $yönetici_numara = $_POST['yönetici_numara'];
        $yönetici_mail = $_POST['yönetici_mail'];
        $yönetici_sifre = password_hash($_POST['yönetici_sifre'], PASSWORD_BCRYPT);
        $etiket = ""; // Etiket boş kalacak
        $personel_statusu = 1; // Yönetici için statusu 1

        // Telefon numarası veya e-posta zaten var mı kontrol et
        $check_sql = "SELECT id FROM personeller WHERE personel_numara = ? OR personel_mail = ?";
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("ss", $yönetici_numara, $yönetici_mail);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            $error = "Bu telefon numarası veya e-posta zaten kayıtlı!";
        } else {
            // Yönetici ekleme
            $sql = "INSERT INTO personeller (isletme_id, personel_ad, personel_soyad, personel_numara, personel_mail, personel_sifre, etiket, personel_statusu) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("issssssi", $isletme_id, $yönetici_ad, $yönetici_soyad, $yönetici_numara, $yönetici_mail, $yönetici_sifre, $etiket, $personel_statusu);

            if ($stmt->execute()) {
                $success = "Yönetici başarıyla eklendi.";
                // Başarı ile kayıt sonrası yönlendirme
                header("Location: personel_kayit.php?success=" . urlencode($success));
                exit();
            } else {
                $error = "Kayıt eklenirken hata oluştu: " . $stmt->error;
            }
        }
    }
}

// Başarı veya hata mesajını göstermek için kontrol
if (isset($_GET['success'])) {
    $success = $_GET['success'];
}
if (isset($_GET['error'])) {
    $error = $_GET['error'];
}
?>

<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <meta name="description" content="">
        <meta name="author" content="">

        <title>Personel Kayıt</title>

        <!-- CSS FILES -->      
        <link rel="preconnect" href="https://fonts.googleapis.com">
        
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

        <link href="https://fonts.googleapis.com/css2?family=Unbounded:wght@300;400;700&display=swap" rel="stylesheet">

        <link href="css/bootstrap.min.css" rel="stylesheet">

        <link href="css/bootstrap-icons.css" rel="stylesheet">

        <link href="css/tooplate-mini-finance.css" rel="stylesheet">
<!--

Tooplate 2135 Mini Finance

https://www.tooplate.com/view/2135-mini-finance

Bootstrap 5 Dashboard Admin Template

-->
    </head>
    
    <body>
        <header class="navbar sticky-top flex-md-nowrap">
            <div class="col-md-3 col-lg-3 me-0 px-3 fs-6">
                <a class="navbar-brand" href="index.html">
                    <i class="bi-box"></i>
                  ENPDKS
                </a>
            </div>

            <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <form class="custom-form header-form ms-lg-3 ms-md-3 me-lg-auto me-md-auto order-2 order-lg-0 order-md-0" action="#" method="get" role="form">
                <input class="form-control" name="search" type="text" placeholder="Search" aria-label="Search">
            </form>

            <div class="navbar-nav me-lg-2">
                <div class="nav-item text-nowrap d-flex align-items-center">
                    <div class="dropdown ps-3">
                        <a class="nav-link dropdown-toggle text-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi-bell"></i>
                            <span class="position-absolute start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
                                <span class="visually-hidden">New alerts</span>
                            </span>
                        </a>

                        <ul class="dropdown-menu notifications-block-wrap bg-white shadow">
                            <small>Notifications</small>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-success">
                                        <i class="notifications-icon bi-check-circle-fill"></i>
                                    </div>

                                    <div>
                                        <span>Your account has been created successfuly.</span>

                                        <p>12 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block border-bottom pb-2 mb-2">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-info">
                                        <i class="notifications-icon bi-folder"></i>
                                    </div>

                                    <div>
                                        <span>Please check. We have sent a Daily report.</span>

                                        <p>10 days ago</p>
                                    </div>
                                </a>
                            </li>

                            <li class="notifications-block">
                                <a class="dropdown-item d-flex align-items-center" href="#">
                                    <div class="notifications-icon-wrap bg-danger">
                                        <i class="notifications-icon bi-question-circle"></i>
                                    </div>

                                    <div>
                                        <span>Account verification failed.</span>

                                        <p>1 hour ago</p>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>

                    <div class="dropdown ps-1">
                        <a class="nav-link dropdown-toggle text-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi-three-dots-vertical"></i>
                        </a>

                        <div class="dropdown-menu dropdown-menu-social bg-white shadow">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-4">
                                        <a class="dropdown-item text-center" href="#">
                                            <img src="images/social/search.png" class="profile-image img-fluid" alt="">
                                            <span class="d-block">Google</span>
                                        </a>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-4">
                                        <a class="dropdown-item text-center" href="#">
                                            <img src="images/social/spotify.png" class="profile-image img-fluid" alt="">
                                            <span class="d-block">Spotify</span>
                                        </a>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-4">
                                        <a class="dropdown-item text-center" href="#">
                                            <img src="images/social/telegram.png" class="profile-image img-fluid" alt="">
                                            <span class="d-block">Telegram</span>
                                        </a>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-4">
                                        <a class="dropdown-item text-center" href="#">
                                            <img src="images/social/snapchat.png" class="profile-image img-fluid" alt="">
                                            <span class="d-block">Snapchat</span>
                                        </a>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-4">
                                        <a class="dropdown-item text-center" href="#">
                                            <img src="images/social/tiktok.png" class="profile-image img-fluid" alt="">
                                            <span class="d-block">Tiktok</span>
                                        </a>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-4">
                                        <a class="dropdown-item text-center" href="#">
                                            <img src="images/social/youtube.png" class="profile-image img-fluid" alt="">
                                            <span class="d-block">Youtube</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="dropdown px-3">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid" alt="">
                        </a>
                        <ul class="dropdown-menu bg-white shadow">
                            <li>
                                <div class="dropdown-menu-profile-thumb d-flex">
                                    <img src="images/medium-shot-happy-man-smiling.jpg" class="profile-image img-fluid me-3" alt="">

                                    <div class="d-flex flex-column">
                                        <small>Thomas</small>
                                        <a href="#">thomas@site.com</a>
                                    </div>
                                </div>
                            </li>

                            <li>
                                <a class="dropdown-item" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profile
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Settings
                                </a>
                            </li>

                            <li>
                                <a class="dropdown-item" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Help
                                </a>
                            </li>

                            <li class="border-top mt-3 pt-2 mx-4">
                                <a class="dropdown-item ms-0 me-0" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </header>
            <div class="container-fluid">
            <div class="row">
                <nav id="sidebarMenu" class="col-md-3 col-lg-3 d-md-block sidebar collapse">
                    <div class="position-sticky py-4 px-3 sidebar-sticky">
                        <ul class="nav flex-column h-100">
                            <li class="nav-item">
                                <a class="nav-link " aria-current="page" href="panel.php">
                                    <i class="bi-house-fill me-2"></i>
                                    Ana Ekran
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a class="nav-link active" href="personel_kayit.php">
                                    Personel Kayıt
                                </a>
                            </li>
                            
                                <li class="nav-item">
                                <a class="nav-link " href="personel_liste.php">
                                    Personel Listesi
                                </a>
                            </li>
                              <li class="nav-item">
                                <a class="nav-link " href="konum.php">
                                    Konum İşlemleri
                                </a>
                            </li>
                             <li class="nav-item">
                                <a class="nav-link " href="bildirim.php">
                                    Bildirim Gönder
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link " href="bildirim_liste.php">
                                    Bildirim Listesi
                                </a>
                            </li>
 <ul class="nav">
        <li class="nav-item">
            <a class="nav-link " onclick="toggleSubMenu()">Grup İşlemleri</a>
            <div class="sub-menu">
                <p><a href="etiket_ekle.php">Grup Ekle</a></p>
                <p><a href="etiketler.php">Grupları Listele</a></p>
            </div>
        </li>
    </ul>
 <a class="nav-link" href="isletme_ayarlari.php">
                                    <i class="bi-gear me-2"></i>
                                    İşletme Ayarları
                                </a>
                            </li>



                            <li class="nav-item">
                                <a class="nav-link" href="wallet.html">
                                    <i class="bi-wallet me-2"></i>
                                    My Wallet
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="profile.html">
                                    <i class="bi-person me-2"></i>
                                    Profile
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="setting.html">
                                    <i class="bi-gear me-2"></i>
                                    Settings
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="help-center.html">
                                    <i class="bi-question-circle me-2"></i>
                                    Help Center
                                </a>
                            </li>

                            <li class="nav-item featured-box mt-lg-5 mt-4 mb-4">
                                <img src="images/credit-card.png" class="img-fluid" alt="">

                                <a class="btn custom-btn" href="#">Upgrade</a>
                            </li>

                            <li class="nav-item border-top mt-auto pt-2">
                                <a class="nav-link" href="#">
                                    <i class="bi-box-arrow-left me-2"></i>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </nav>
                  <style>
           .sub-menu {
            display: none;
            margin-left: 20px;
        }
        .nav-link {
            cursor: pointer;
        }
        .sub-menu p {
            color: black; /* Paragrafların rengi siyah */
            margin: 0; /* Varsayılan margin'i sıfırlamak için */
        }
    </style>
    
     <script>
        function toggleSubMenu() {
            const subMenu = document.querySelector('.sub-menu');
            subMenu.style.display = subMenu.style.display === 'none' || subMenu.style.display === '' ? 'block' : 'none';
        }
    </script>
    
<main class="main-wrapper col-md-9 ms-sm-auto py-4 col-lg-9 px-md-4 border-start">
    <div class="title-group mb-3">
        <h1 class="h2 mb-0">Personel İşlemleri</h1>
    </div>

    <div class="row my-4">
        <div class="col-lg-7 col-12">
            <div class="custom-block bg-white">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="personel-tab" data-bs-toggle="tab" data-bs-target="#personel-tab-pane" type="button" role="tab" aria-controls="personel-tab-pane" aria-selected="true">Personel Ekle</button>
                    </li>

                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="yönetici-tab" data-bs-toggle="tab" data-bs-target="#yönetici-tab-pane" type="button" role="tab" aria-controls="yönetici-tab-pane" aria-selected="false">Yönetici Ekle</button>
                    </li>
                </ul>

                <div class="tab-content" id="myTabContent">
                    <!-- Personel Ekleme Formu -->
                    <div class="tab-pane fade show active" id="personel-tab-pane" role="tabpanel" aria-labelledby="personel-tab" tabindex="0">
                        <h6 class="mb-4">Personel Ekle</h6>

                        <form class="custom-form profile-form" action="" method="post" role="form">
                            <input class="form-control" type="text" name="personel_ad" id="personel_ad" placeholder="Ad" required>
                            <input class="form-control" type="text" name="personel_soyad" id="personel_soyad" placeholder="Soyad" required>
                            <input class="form-control" type="text" name="personel_numara" id="personel_numara" placeholder="Telefon Numarası" required>
                            <input class="form-control" type="email" name="personel_mail" id="personel_mail" placeholder="E-posta" required>
                            <input class="form-control" type="password" name="personel_sifre" id="personel_sifre" placeholder="Şifre" required>
                            
                          <select class="form-control" name="konum_id" id="konum_id" required>
    <option value="">Konum Seçin</option>
    <?php foreach ($konumlar as $row) : ?>
        <option value="<?php echo $row['id']; ?>"><?php echo $row['ad']; ?></option>
    <?php endforeach; ?>
</select>


                            <div class="d-flex">
                                <button type="reset" class="btn btn-outline-danger form-control me-3">Sıfırla</button>
                                <button type="submit" class="btn btn-primary form-control ms-2">Kaydet</button>
                            </div>
                        </form>

                        <?php if (!empty($success)) : ?>
                            <p style="color: green;"><?php echo $success; ?></p>
                        <?php endif; ?>

                        <?php if (!empty($error)) : ?>
                            <p style="color: red;"><?php echo $error; ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Yönetici Ekleme Formu -->
                    <div class="tab-pane fade" id="yönetici-tab-pane" role="tabpanel" aria-labelledby="yönetici-tab" tabindex="0">
                        <h6 class="mb-4">Yönetici Ekle</h6>

                        <form class="custom-form profile-form" action="" method="post" role="form">
                            <input class="form-control" type="text" name="yönetici_ad" id="yönetici_ad" placeholder="Ad" required>
                            <input class="form-control" type="text" name="yönetici_soyad" id="yönetici_soyad" placeholder="Soyad" required>
                            <input class="form-control" type="text" name="yönetici_numara" id="yönetici_numara" placeholder="Telefon Numarası" required>
                            <input class="form-control" type="email" name="yönetici_mail" id="yönetici_mail" placeholder="E-posta" required>
                            <input class="form-control" type="password" name="yönetici_sifre" id="yönetici_sifre" placeholder="Şifre" required>

                            <div class="d-flex">
                                <button type="reset" class="btn btn-outline-danger form-control me-3">Sıfırla</button>
                                <button type="submit" class="btn btn-primary form-control ms-2">Kaydet</button>
                            </div>
                        </form>
                        
                        <?php if (!empty($success)) : ?>
                            <p style="color: green;"><?php echo $success; ?></p>
                        <?php endif; ?>

                        <?php if (!empty($error)) : ?>
                            <p style="color: red;"><?php echo $error; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>


        <!-- JAVASCRIPT FILES -->
        <script src="js/jquery.min.js"></script>
        <script src="js/bootstrap.bundle.min.js"></script>
        <script src="js/custom.js"></script>