<?php
session_start();
include 'db.php'; // Veritabanı bağlantısı

// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Kullanıcı oturumu kontrolü
if (!isset($_SESSION['user_id'])) {
    header("Location: personel_giris.php"); // Giriş yapmamışsa login sayfasına yönlendir
    exit();
}

// İşe başlama işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['scan_qr_code'])) {
    $personel_id = $_SESSION['user_id'];
    $qrCodeData = $_POST['qr_code_data']; // QR kodundan gelen veri

    // QR kod verisini kontrol et
    parse_str($qrCodeData, $data);
    if (isset($data['action']) && $data['action'] === 'start_work' && isset($data['personel_id']) && $data['personel_id'] == $personel_id) {
        // İşe başlama işlemi
        $sql = "INSERT INTO is_giris_cikis (personel_id, ise_baslangic) VALUES (?, NOW())";
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
            die("Sorgu hazırlama hatası: " . $conn->error);
        }

        $stmt->bind_param("i", $personel_id);
        $stmt->execute();
        $stmt->close();

        echo "İşe başlama işlemi başarılı!";
    } else {
        echo "Geçersiz QR kodu!";
    }
}

// Kullanıcı bilgilerini al
$sql = "SELECT personel_ad, personel_soyad FROM personeller WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die("Sorgu hazırlama hatası: " . $conn->error);
}

$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$stmt->bind_result($personel_ad, $personel_soyad);
$stmt->fetch();
$stmt->close();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İş Giriş Çıkış</title>
    <script src="https://unpkg.com/@zxing/library@latest"></script>
</head>
<body>
    <h2>Hoşgeldiniz, <?php echo htmlspecialchars($personel_ad . ' ' . $personel_soyad); ?></h2>

    <button id="start-button">QR Kodu Tara</button>
    <video id="preview" style="display:none;"></video>
    <div id="result"></div>

    <form method="POST" id="qr-form" style="display:none;">
        <input type="hidden" name="qr_code_data" id="qr_code_data">
        <button type="submit" name="scan_qr_code">QR Kodu Gönder</button>
    </form>

    <button onclick="endWork()">Çıkış Yap</button>
    <a href="logout.php">Çıkış Yap</a>

    <script>
        const codeReader = new ZXing.BrowserQRCodeReader();
        const startButton = document.getElementById('start-button');
        const resultElement = document.getElementById('result');
        const qrForm = document.getElementById('qr-form');
        const qrCodeDataInput = document.getElementById('qr_code_data');

        startButton.addEventListener('click', () => {
            codeReader.decodeFromVideoDevice(null, 'preview', (result, err) => {
                if (result) {
                    resultElement.textContent = result.text;
                    qrCodeDataInput.value = result.text; // QR kod verisini form alanına ekle
                    qrForm.style.display = 'block'; // Formu göster
                    codeReader.reset(); // Tarayıcıyı sıfırla
                }
                if (err && !(err instanceof ZXing.NotFoundException)) {
                    console.error(err);
                }
            });
        });

        function endWork() {
            // İşten çıkış işlemi için gerekli kod buraya yazılabilir
            alert("Çıkış yapıldı!");
        }
    </script>
</body>
</html>
