<?php
// CORS başlıkları
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json; charset=UTF-8");

// OPTIONS isteklerini yanıtla
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Hata raporlamayı etkinleştir
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    include 'db.php';

    if (!$conn) {
        throw new Exception("Veritabanı bağlantısı kurulamadı");
    }

    $sql = "SELECT * FROM yemek_tarif ORDER BY id DESC";
    $result = $conn->query($sql);

    if (!$result) {
        throw new Exception("Sorgu çalıştırılamadı: " . $conn->error);
    }

    $tarifler = [];
    $kategori_adlari = [
        1 => "Hamur İşi",
        2 => "Kahvaltılık",
        3 => "Et Yemekleri",
        4 => "Mangal",
        5 => "Vegan",
        6 => "Salata",
        7 => "Çorba"
    ];

    while ($row = $result->fetch_assoc()) {
        $kategori_id = $row["kategori_id"];
        $tarifler[] = [
            "id" => (int)$row["id"],
            "kategori_id" => (int)$kategori_id,
            "kategori_adi" => $kategori_adlari[$kategori_id] ?? "Bilinmeyen Kategori",
            "yemek_adi" => $row["yemek_adi"],
            "pf_1" => $row["pf_1"],
            "pf_2" => $row["pf_2"],
            "video_url" => $row["video_url"] ?: null,
            "resim" => !empty($row["resim"]) ? $row["resim"] : null
        ];
    }

    echo json_encode($tarifler, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "hata" => true,
        "mesaj" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>