<?php
include 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $kategori_id = $_POST['kategori_id'];
    $yemek_adi = $_POST['yemek_adi'];
    $pf_1 = $_POST['pf_1'];
    $pf_2 = $_POST['pf_2'];
    $video_url = !empty($_POST['video_url']) ? $_POST['video_url'] : NULL;
    
    // Görsel Yükleme İşlemi
    $resim = NULL;
    if (!empty($_FILES['resim']['name'])) {
        $target_dir = "yemek_gorsel/"; // Klasör adı
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true); // Klasör yoksa oluştur
        }
        $resim = $target_dir . basename($_FILES["resim"]["name"]);
        move_uploaded_file($_FILES["resim"]["tmp_name"], $resim);
    }

    $stmt = $conn->prepare("INSERT INTO yemek_tarif (kategori_id, yemek_adi, pf_1, pf_2, video_url, resim) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssss", $kategori_id, $yemek_adi, $pf_1, $pf_2, $video_url, $resim);

    if ($stmt->execute()) {
        echo "Yemek tarifi başarıyla eklendi!";
    } else {
        echo "Hata: " . $stmt->error;
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yemek Tarifi Ekle</title>
</head>
<body>
    <h2>Yeni Yemek Tarifi Ekle</h2>
    <form action="" method="post" enctype="multipart/form-data">
        <label>Kategori:</label>
        <select name="kategori_id" required>
            <option value="1">Hamur İşi</option>
            <option value="2">Kahvaltılık</option>
            <option value="3">Et Yemekleri</option>
            <option value="4">Mangal</option>
            <option value="5">Vegan</option>
            <option value="6">Salata</option>
            <option value="7">Çorba</option>
        </select>
        <br>

        <label>Yemek Adı:</label>
        <input type="text" name="yemek_adi" required>
        <br>

        <label>Paragraf 1:</label>
        <textarea name="pf_1" required></textarea>
        <br>

        <label>Paragraf 2:</label>
        <textarea name="pf_2" required></textarea>
        <br>

        <label>Video URL (Varsa):</label>
        <input type="text" name="video_url">
        <br>

        <label>Yemek Görseli:</label>
        <input type="file" name="resim" accept="image/*">
        <br>

        <button type="submit">Yemek Tarifini Kaydet</button>
    </form>
</body>
</html>
